<?php
session_start();
if (!isset($_SESSION['usuario'])){
	header ("Location: ../../index.php");
}
include_once('../../modelo/general.php');
require_once "class.writeexcel_workbook.inc.php";
require_once "class.writeexcel_worksheet.inc.php";

$fname = tempnam("/tmp", "listado_articulos.xls");
$workbook =& new writeexcel_workbook($fname);
$worksheet =& $workbook->addworksheet('Listado_Articulos');
//$worksheet2 =& $workbook->addworksheet('Another sheet');
//$worksheet3 =& $workbook->addworksheet('And another');

#######################################################################
#
# Write a general heading
#
$worksheet->set_column('A:B:C:D:E', 10);
$heading  =& $workbook->addformat(array(
                                        bold    => 1,
                                        color   => 'blue',
                                        size    => 11,
                                        merge   => 1,
                                        ));

$headings = array(utf8_decode('Listado General de Artículos'), '','','','');
$worksheet->write_row('A1', $headings, $heading);

#######################################################################
#
# Some text examples
#
$text_format =& $workbook->addformat(array(
                                            bold    => 1,
                                            italic  => 1,
                                            color   => 'black',
                                            size    => 10,
                                            font    => 'Comic Sans MS'
                                        ));

$worksheet->write('A2', "Id",$text_format);
$worksheet->write('B2', utf8_decode("Código"), $text_format);
$worksheet->write('C2', utf8_decode("Nombre del Artículo"), $text_format);
$worksheet->write('D2', "Unidad Medida", $text_format);
$worksheet->write('E2', "Cantidad",$text_format);

//llenar hoja con datos 
include_once('bd.php');
$link=conectar();

if($link!=0)
{
	$sql="select 
		a_producto.id_prod as id, 
		a_producto.codigo,
		a_producto.nombre,
		gen_unidad_medida.nombre_unidad as medida,
		a_producto.cantidad, a_producto.status 
	from
		a_producto, gen_unidad_medida 
	where
		a_producto.id_unidad_medida=gen_unidad_medida.id_med";
	
	$rs=ejecutar($sql);
	//AUDITORIA
	auditoria($sql,'Muestra en un libro de excel todos los articulos', 'listado_excel_articulos.php');
}
else{
	die("error de conexion");
}
cerrar_conexion($link);
$f=3;

while ($row=pg_fetch_array($rs)){
	$worksheet->write("A$f", $row['id'],$text_format);
	$worksheet->write("B$f", $row['codigo'], $text_format);
	$worksheet->write("C$f", $row['nombre'], $text_format);
	$worksheet->write("D$f", $row['medida'], $text_format);
	$worksheet->write("E$f", $row['cantidad'],$text_format);
	$f=$f+1;
}

#######################################################################
#
# Some numeric examples
#
/*$num1_format =& $workbook->addformat(array(num_format => '$#,##0.00'));
$num2_format =& $workbook->addformat(array(num_format => ' d mmmm yyy'));

$worksheet->write('A4', "Numbers");
$worksheet->write('B4', 1234.56);
$worksheet->write('A5', "Formatted numbers");
$worksheet->write('B5', 1234.56, $num1_format);
$worksheet->write('A6', "Formatted numbers");
$worksheet->write('B6', 37257, $num2_format);*/

#######################################################################
#
# Formulae
#
/*$worksheet->set_selection('B7');
$worksheet->write('A7', 'Formulas and functions, "=SIN(PI()/4)"');
$worksheet->write('B7', '=SIN(PI()/4)');*/

#######################################################################
#
# Hyperlinks
#
/*$worksheet->write('A8', "Hyperlinks");
$worksheet->write('B8',  'http://www.php.net/');*/

#######################################################################
#
# Images
#
/*$worksheet->write('A1', "Images");
$worksheet->insert_bitmap('B10', 'php.bmp', 16, 8);*/

#######################################################################
#
# Misc
#
/*$worksheet->write('A17', "Page/printer setup");
$worksheet->write('A18', "Multiple worksheets");*/

$workbook->close();

header("Content-Type: application/x-msexcel; name=\"listado_articulos.xls\"");
header("Content-Disposition: inline; filename=\"listado_articulos.xls\"");
$fh=fopen($fname, "rb");
fpassthru($fh);
unlink($fname);
?>
