//codigo de estatus de ajax
var S_READY = 4;

/**
* Crear objeto XmlHttpRequest de manera
* portable entre browsers IE y FF. Retorna
* una referencia al objeto listo para usarse
* en comunicacion Ajax
*/
function getHttpObject()
{
	var obj = null;
	if (window.XMLHttpRequest) {
		obj = new XMLHttpRequest();
	} else if (window.ActiveXObject) {
		obj = new ActiveXObject("Microsoft.XMLHTTP");
	}
	return obj;
}


/**
* Invocar servicio Ajax
* httpMethod: String GET o POST
* uri: Path del servicio, no incluir el contexto. Ejemplo: /action/xxxx/yyyy
* divResponse: ID del DIV donde se muestra la respuesta en caso de que sea HTML
* divProgress: ID del DIV a mostrar mientras se ejecuta la llamada
* formName: Nombre del formulario en caso que httpMethod sea igual a POST
* afterResponseFn: Apuntador a funcion a ejecutar despues de mostrar una respuesta HTML
* onErrorFn: Apuntador a funcion a ejecutar en caso de error http 500, 403, 404, 401, etc.
*            Puede utilizarse para restaurar los DIVs que se escondieron antes de invocar
*            esta funcion.
*/
function ajaxCall(httpMethod, uri, divResponse, divProgress, formName, afterResponseFn, onErrorFn)
{

		//mostrar indicador de progreso
		var progress = document.getElementById(divProgress)
		if (progress!=null)
			progress.style.display='';

		//ensamblar el URL
		//var server = "${def:httpserver}";
		var server = "http://localhost/";
		//var url = server + "${def:context}" + uri;
		var url = server + "red_privada/" + uri;
		if (url.indexOf("?")>0)
			url = url + "&random=" + Math.random();
		else
			url = url + "?random=" + Math.random();
		
		//ensamblar formulario
		var data = null
		if (formName!=null)
			data = getFormValues(formName);
		
		//send request
		var http = getHttpObject();
		
		//manejador de respuesta AJAX
		http.onreadystatechange = function ()
		{
			if (http.readyState == S_READY) 
			{
			
				var contentType = http.getResponseHeader("Content-type");
				var text = http.responseText;
		
				//verificacion de sesion de seguridad activa (redirect a login)
				if (text.indexOf("_ajax_VE8374yz_")>0) 
				{
						window.location="${def:context}/index.htm";
				} 
				else 
				{
		
					//apagar indicador de progreso
					if (progress!=null)
						progress.style.display='none';
					
					//verificacion de error y seguridad
					if (http.status == 500 || http.status == 400) 
						alert("Error en el sistema.");
					else if (http.status == 403)
						alert("Acceso denegado.");
					else if (http.status == 404)
						alert("El servicio solicitado no existe.");
					else if (http.status == 401)
						alert("El servicio solicitado requiere comunicaci�n v�a SSL.");
					else 
					{
						//ok - responder de acuerdo al tipo de contenido
						if( contentType.indexOf("text/javascript")>=0 ) 
						{
							eval(text);
						} 
						else 
						{
							var div = document.getElementById(divResponse);
							div.innerHTML = text;
							div.style.display='';
							if (afterResponseFn!=null)
								afterResponseFn();
						}
					}
					
					if (http.status != 200) {
						if (onErrorFn!=null)
							onErrorFn();
					}
					
				}
		   	}
		} 
		
    	http.open(httpMethod, url, true);
    	http.setRequestHeader("Content-Type","application/x-www-form-urlencoded; charset=UTF-8");
    	if (data!=null)
    		http.setRequestHeader("Content-length", data.length);
    	http.send(data);

		return false;

}


/**
* Limpiar los controles de un formulario,
* los comboBox se ubican en el 1er elemento, el
* atributo value del resto de los controles se
* pone en "" vacio. El focus se pone en el 1er
* control activo.
* formName: nombre del formulario
*/
function clearForm(formName)
{
	var f = document.forms[formName];
	for (i=0;i<f.elements.length;i++)
	{

		var e = f.elements[i];
		if (e.type=="text" || e.type=="hidden" || e.tagName=="TEXTAREA")
		{
			e.value = "";
		}
		if (e.tagName=="SELECT")
		{
			e.options.selectedIndex = 0;
		}
		if (e.type=="checkbox")
		{
			e.checked = false;
		}
	}
	//setFocusOnForm(f);
}

/**
* Poner el focus en el 1er control
* activo de un formulario.
* f: Objeto que representa un formulario
*/
function setFocusOnForm(f)
{
	var n = f.elements.length;
	for (i=0;i<n;i++) {
		var e = document.forms[0].elements[i];
		if (e.readOnly == false && e.type!="hidden") 
		{
			e.focus();
			return;
		}
	}
}

/**
* Posicionar un DIV justo debajo de un 
* control de formulario, alineado a la
* izquierda.
* element: objeto que representa al control
* box: objeto que representa al DIV
*/
function moveBox(element, box) 
{

	/* 
	NOTE:
	Original author: JTricks.com :: http://www.jtricks.com/ 
	*/

	var offset = 3;
	if (isIE())
		offset = -13;

	  var cleft = 0;
	  var ctop = 0;
	  var obj = element;
	  while (obj.offsetParent) {
	    cleft += obj.offsetLeft;
	    ctop += obj.offsetTop;
	    obj = obj.offsetParent;
	  }
	  box.style.left = cleft + 'px';
	  ctop += element.offsetHeight + offset;
	  if (document.body.currentStyle &&
	    document.body.currentStyle['marginTop']) {
	    ctop += parseInt(
	      document.body.currentStyle['marginTop']);
	  }
	  box.style.top = ctop + 'px';

}

/*
* Crear un DIV que contenga un IFRAME
* y posicionar el DIV con su contenido
* abajo y alineado a la izquierda del
* elemento cuyo ID es el valor del par�metro objID
*/		
function showBox(objID, width, height, url) 
{

	/* 
	NOTE:
	Original author: JTricks.com :: http://www.jtricks.com/ 
	*/

	var obj = document.getElementById(objID);
	var newID = objID + "_popup";
	var borderStyle = "lightgrey 1px solid"
	var boxdiv = document.getElementById(newID);
	
	  if (boxdiv != null) {
	    if (boxdiv.style.display=='none') {
	    	if (url!=null) 
	    	{
	    		var f = window.frames[objID + "_iframe"];
	    		f.document.open();
    			f.document.write("<center>");
    			f.document.write("<br><br>");
    			f.document.write("<img src='../images/progress.gif'>");
	    		f.document.write("<span style='padding-left:10px;font-family:Arial;font-size:9pt;font-weight:bold'>Loading...</span>");
    			f.document.write("</center>");
	    		f.document.close();
	      		f.location = url;
	      	}
	      moveBox(obj, boxdiv);
	      boxdiv.style.display='block';
	    } else
	      boxdiv.style.display='none';
	    return false;
	  }
	
	  boxdiv = document.createElement('div');
	  boxdiv.setAttribute('id', newID);
	  boxdiv.style.display = 'none';
	  boxdiv.style.position = 'absolute';
	  boxdiv.style.width = width + 'px';
	  boxdiv.style.height = height + 'px';
	  boxdiv.style.border = borderStyle;
	  boxdiv.style.backgroundColor = '#F7F7F7';
	  boxdiv.style.padding = "0px";
	
	  var contents = document.createElement('iframe');
	  contents.scrolling = 'no';
	  contents.frameBorder = '0';
	  contents.style.width = width + 'px';
	  contents.style.height = height + 'px';
	  contents.marginHeight = 0;
	  contents.marginWidth = 0;
	  contents.setAttribute('id', objID + "_iframe");
	  contents.setAttribute('name', objID + "_iframe");
	  
	  boxdiv.appendChild(contents);
	  document.body.appendChild(boxdiv);

	  if (url!=null) {
	  		var f = window.frames[objID + "_iframe"];
			f.document.open();
			f.document.write("<center>");
			f.document.write("<br><br>");
			f.document.write("<img src='${def:context}/images/progress.gif'>");
			f.document.write("<span style='padding-left:10px;font-family:Arial;font-size:9pt;font-weight:bold'>Loading...</span>");
			f.document.write("</center>");
			f.document.close();
			f.location = url;
	  }

	  moveBox(obj, boxdiv);
	  boxdiv.style.display = 'block';
	  
	  return false;
	  
}	

/**
* Esconde un DIV + IFRAME abierto con la
* funci�n showBox()
*/
function closeBox(objID)
{
	var obj = document.getElementById(objID);
	if (!obj.readonly)
		obj.focus();
		
	document.getElementById(objID + "_popup").style.display = "none";
}


/*
* Retorna TRUE si el navegador
* es Internet Explorer
*/
function isIE()
{
	if (navigator.appName.indexOf("Explorer")>0)
		return true
	else
		return false
}

/*
* Retorna TRUE si el valor representa una fecha
* de lo contrario retorna FALSE. Si el a�o viene con 2 d�gitos
* y en menor que 30, se asume el 20XX, de lo contrario 19XX.
* value: String que representa una fecha con formato dd-mm-yyyy o dd/mm/yyyy
*/
function isValidDate(value)
{

	var d = convertDate(value)
	if (d==null)
		return false;
	else
		return true;
}

/*
* Retorna un objeto DATE si el valor representa una fecha
* de lo contrario retorna NULL. Si el a�o viene con 2 d�gitos
* y es menor que 30, se asume el 20XX, de lo contrario 19XX.
* value: String que representa una fecha con formato dd-mm-yyyy o dd/mm/yyyy
*/
function convertDate(value)
{

	value = value.replace(new RegExp("/", "g") ,"-");
	var values = value.split("-");
	
	if (values.length!=3)
		return null;
	
	var day = values[0];
	var month = values[1];
	var year = values[2];

	if (year.length!=2 && year.length!=4)
		return null;

	if (year.length==2 && parseInt(year)<30)
		year = "20" + year;
	else if (year.length==2 && parseInt(year)>=30)
		year = "19" + year;

	month = month-1;

	var dteDate = new Date(year,month,day);
	
	var r = ((day==dteDate.getDate()) && (month==dteDate.getMonth()) && (year==dteDate.getFullYear()));
		
	if (r)
	 return dteDate;
	else
		return null;

}


/*
* Mostrar un Calendario debajo y alineado
* a la izquierda del elemento designado
* por el parametro objID. El elemento debe
* ser un textbox.
* objID: ID del elemento
*/
function calendarOpen(objID, lboundID, uboundID)
{
	var d = document.getElementById(objID).value;
	var url = "${def:context}/action/calendar?id=" + objID + "&date=" + d;
	if (lboundID != null)
		url = url + "&date.lbound=" + document.getElementById(lboundID).value;
	if (uboundID != null)
		url = url + "&date.ubound=" + document.getElementById(uboundID).value;
	showBox(objID, 240,154, url);
}

/**
* Retorna valor seleccionado en el calendario
* poniendolo dentro del textbox asociado y 
* cierra el calendario
* objID: ID del textbox asociado al calendario
* sdate: String que representa una fecha en formato dd-mm-yyyy
*/
function calendarReturnValue(objID, sdate)
{
	document.getElementById(objID + "_popup").style.display = "none";
	document.getElementById(objID).value = sdate;
	return false;
}

/**
* Filtrar caracteres no permitidos en campos fecha, se usa
* de esta manera: document.forms1.text1.onkeypress = keypressDate
* en el evento onload del body.
*/
function keypressDate(e) 
{ 
	var mask = "0123456789-";
	var keyCode = e ? e.which : window.event.keyCode;
	var key = String.fromCharCode(keyCode);
	if (mask.indexOf(key)==-1 && keyCode != 8 && keyCode!=0 && keyCode!=13)
		return false;
}

/**
* Filtrar caracteres no permitidos en campos enteros, se usa
* de esta manera: document.forms1.text1.onkeypress = keypressInteger
* en el evento onload del body.
*/
function keypressInteger(e) 
{ 
	var mask = "0123456789";
	var keyCode = e ? e.which : window.event.keyCode;
	var key = String.fromCharCode(keyCode);
	if (mask.indexOf(key)==-1 && keyCode != 8 && keyCode!=0 && keyCode!=13)
		return false;
} 

/**
* Filtrar caracteres no permitidos en campos con decimales, se usa
* de esta manera: document.forms1.text1.onkeypress = keypressDouble
* en el evento onload del body. Solo acepta el punto "." como separador
* de decimales.
*/
function keypressDouble(e) 
{ 
	var mask = "0123456789.";
	var keyCode = e ? e.which : window.event.keyCode;
	var elem = e ? e.target : window.event.srcElement;
	var key = String.fromCharCode(keyCode);
	if (mask.indexOf(key)==-1 && keyCode != 8 && keyCode!=0 && keyCode!=13)
		return false;
		
	if (key=="." && elem.value.indexOf(".") > -1)
		return false;

} 

/**
* Retorna la trama requerida para hacer un POST del
* formulario indicado usando Ajax
* formName: Nombre del formulario 
*/

function getFormValues(formName)
{

	returnString ="";
	
	if( formName == "" ) return returnString;
	
	formElements=document.forms[formName].elements;
	
	for ( var i=formElements.length-1; i>=0; --i ) {
		if (formElements[i].name!=""){ 
			//a�ade elementos radio y checkbox
			if (formElements[i].type=="checkbox" && !formElements[i].checked){
			//este checkbox si no ha sido seleccionado es ignorado
			}else{
				if (formElements[i].type=="radio" && !formElements[i].checked){
				//este radio si no ha sido seleccionado es ignorado
				}
				else {
					returnString = returnString + formElements[i].name + "=" + encodeURI(formElements[i].value) + "&";
				}
			}
		}
	}
	
	returnString = returnString.substring(0, returnString.length - 1);
	return returnString;

}

/**
* Retorna checkboxes o radiobutton con la propiedad
* checked = true
* radioName: Nombre del checkbox o radiobutton
* radioValue: Valor del checkbox o radiobutton
* formName: Nombre del formulario 
*/

function setCheckboxValue(radioName,radioValue,formName)
{
	if( formName == "") { 
		//si forName es nulo no hace nada
		return;
	}else{
		formElements=document.forms[formName].elements;
	}
	for ( var i=formElements.length-1; i>=0; --i ) {
		if (formElements[i].name == radioName && (formElements[i].type=="radio" || formElements[i].type=="checkbox") ){ 
			//a�ade elementos radio y checkbox
			if (formElements[i].value==radioValue){
			formElements[i].checked = true;
			return;
			}
		}
	}
}

/**
* Retorna combos con la propiedad
* select = true
* comboName: Nombre del combo
* comboValue: Valor del combo
* formName: Nombre del formulario 
*/

function setComboValue(comboName,comboValue,formName)
{	   
   var combo = document.forms[formName].elements[comboName];
   var cantidad = combo.length;
   for (i = 0; i < cantidad; i++) {
      if (combo[i].value == comboValue) {
         combo[i].selected = true;
      }
    }   
}
   	
function replaceDecimal(elem)
{
	var value = elem.value;
	elem.value = value.replace(new RegExp(",", "g") ,".");
}

/**
* Funciones de soporte para los grid
* contiene funciones para la vista pagina, 
* panel de control, regresar a la pagina indicada,
* y ordenamiento por columnas.
*/

/*
* soporte para la vista paginada y el panel de control
*/
	
//variables de control
var lastPage=0;
var currentPage=0;
var recordsFound=0;

function pageFirst()
{
	currentPage = 1;
	viewPage();
}

function pageLast()
{
	currentPage = lastPage;
	viewPage();
}

function pagePrev()
{
	if (currentPage>1) {
		currentPage=currentPage - 1;
		viewPage();
	} else
		alert("Est� viendo la primera p�gina.");
}

function pageNext()
{
	if (currentPage<lastPage) {
		currentPage=currentPage + 1;
		viewPage();
	} else
		alert("Est� viendo la �ltima p�gina.");
}
	
//ir a la pagina indicada por la variable currentPage
function gotoPage(url)
{
	//llamada Ajax...
	ajaxCall(httpMethod="GET", 
					uri= url + "?pagenumber=" + currentPage, 
					divResponse="response", 
					divProgress="grid-progress", 
					formName=null, 
					afterResponseFn=showCurrentPage, 
					onErrorFn=null);    	
}
	
//mostrar en la pagina de navegacion la pagina actual		
function showCurrentPage()
{
	document.getElementById('currpage').innerHTML=currentPage;	
	document.getElementById('pagecount').innerHTML=lastPage;
	document.getElementById('recordcount').innerHTML=recordsFound;
}
	
//ordenar el grid por la columna indicada
// recordsetId: ID del recordset almacenado en sesion en el servidor
// colName: columna del recordset por la cual se hara el sort
function sortBy(colName, recordsetId)
{
	if (recordsetId == null)
		recordsetId = "query.sql"
		
	//llamada Ajax...
	ajaxCall(httpMethod="GET", 
					uri="/action/sort?rs=" + recordsetId + "&colname=" + colName, 
					divResponse="response", 
					divProgress="grid-progress", 
					formName=null, 
					afterResponseFn=showCurrentPage, 
					onErrorFn=null);    	
}	

/* funciones de soporte para picklist */

var pickControl = null;
var idControl = null;
			
function pickOpen(id, idCtl, url, ancho, altura)
{	
	if (pickControl!=null)
			pickClose();
			
	pickControl = id;
	idControl = idCtl;
	
	showBox(pickControl, ancho, altura, url);
}			

function pickSelect(id, description)
{
	document.getElementById(idControl).value = id;
	document.getElementById(pickControl).value = description;
}

function pickClose()
{
	closeBox(pickControl);
	idControl = null;
	pickControl = null;
}	

//obtener el nodo a partir de el nombre del control 
function getNodeByName(node, name) {
	for (i=0;i<node.childNodes.length;i++) {
		if (node.childNodes[i].name==name)
			return node.childNodes[i];
	}
}

//ajax mio
function objetoAjax(){
	var xmlhttp=false;
	try {
		xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
	} catch (e) {
		try {
			xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
		} catch (E) {
			xmlhttp = false;
		}
	}

	if (!xmlhttp && typeof XMLHttpRequest!='undefined') {

		xmlhttp = new XMLHttpRequest();


	}
	return xmlhttp;
}

function consulta(fuente,div)
{
	eval("var contenedor_"+div+"=document.getElementById('"+div+"');");
	eval("var objeto_"+div+"=objetoAjax();");
	//eval("objeto_"+div+".setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8')");
	eval('objeto_'+div+'.open("GET", "'+fuente+'");');
	eval('objeto_'+div+'.onreadystatechange=function(){ if (objeto_'+div+'.readyState!=4) { contenedor_'+div+'.innerHTML = "<center><img src=img/buscar.gif></center>"; } if (objeto_'+div+'.readyState==4) { contenedor_'+div+'.innerHTML = objeto_'+div+'.responseText; }} ');
	eval('objeto_'+div+'.send(null)');
}


function redireccion(url){
	document.location = url;
}
