<?php

/**

 *      Abstraccion de la Capa de manejo de base de datos

 *      para distintas bases de datos.

 *    @package Base

 *    @author Andres Garcia

 */



class dbms {

/**

* Objeto de Base de Datos a ser utilizado.

* @var objeto

*/

var $obj;

/**

* Tipo de Base de Datos a ser utilizado.

* @var string

*/

var $tipo;

/**

* Registros devueltos por la consulta ejecutada.

* @var integer

*/

var $registros;



var $p_query;



var $p_auditoria;

/**

 *      Inicializacion de variables y verificacion de accesos

 *      para distintas bases de datos.

 *    @param string Tipo de Base de Datos

 *      @param string Indicador de validacion de acceso

 */

function __construct($TipoServidor,$Seguridad='si', $auditoria=false) {

  $this->registros=null;

  $this->p_auditoria=$auditoria;

  if ($this->Control_Acc($Seguridad)) {

    $this->obj=null;

    $this->tipo=null;

    $this->Connectar($TipoServidor);

  } else {

    throw new Exception("Usuario no ha ingresado correctamente al sistema.".$_SESSION['usr_lgn'],1001);

  }

}

/**

 *      Verificacion de accesos para distintas bases de datos.

 *      @param string Indicador de validacion de acceso

 */

protected function Control_Acc($Seguridad){

  if (strtolower($Seguridad)=='si') {

    if (empty($_SESSION['sesion']['usr_lgn'])){

      $vlValido = false;

    }else {

      $vlValido = true;

    }

  } else {

    $vlValido = true;

  }

  return $vlValido;

}

/**

 *    Selector de interfaz para el tipo de bases de datos.

 *    @param string Tipo de Base de Datos

 */

protected function Connectar($TipoServidor) {

  ///$this->CargarConf($TipoServidor);

  switch (strtolower($TipoServidor)){

    case "mysql":

      $this->obj=new dbmy();

      break;

    case "pg":

      $this->obj=new dbpg();

      break;

    case "odbc":

      $this->obj=new dbodbc();

      break;

    case "sybase":

      $this->obj=new dbsyb('produccion');

      break;

    case "sybdesa":

      $this->obj=new dbsyb('desarrollo');

      break;

case "sybbs":

      $this->obj=new dbsyb('sybbs');

      break;

    case "mssql":

      $this->obj=new dbmssql();

      break;

    case "mssql_la":

      $this->obj=new dbmssql('1185');

      break;

    case "mssql_mws":

      $this->obj=new dbmssql('1433');

      break;

  }

  $this->tipo=strtolower($TipoServidor);

}

/**

 *      Ejecucion de instruccion SQL (select)

 *    @param string instruccion SQL a ejecutar

 *      @return objeto Objeto de base de datos

 */

function EjecutarQuery($sql) {

  $this->p_query=str_replace("\r", " ",$sql);

  $this->p_query=str_replace("\n", " ",$sql);

  $salida=$this->obj->EjecutarQuery($sql);

  $this->registros=$this->obj->myrs;

  return $salida;

}

/**

 *      Ejecucion de instruccion transaccional SQL (insert, update, delete)

 *    @param string instruccion SQL a ejecutar

 *      @return objeto Objeto de base de datos

 */

function EjecutarTran($sql) {

  $this->p_query=str_replace("\r", " ",$sql);

  $this->p_query=str_replace("\n", " ",$sql);

  return $this->obj->EjecutarTran($sql);

}

/**

 *      Lectura de un registro del conjunto de registros devueltos por la ejecucion de una instruccion SQL

 *      @return objeto Objeto donde los datos son accesados solo por el nombre del campo

 */

function DataObjeto() {return $this->obj->DataObjeto();}

/**

 *      Lectura de un registro del conjunto de registros devueltos por la ejecucion de una instruccion SQL

 *      @return array Arreglo donde cada elemento es del tipo campo=>valor

 */

function DataArray() {return $this->obj->DataArray();}

/**

 *      Lectura de la informacion de campo del conjunto de registros devueltos por la ejecucion de una instruccion SQL

 *      @param integer Posicion del campo a ser consultado

 *      @return array Arreglo donde cada elemento es del tipo caracteristica=>valor (name, type, len)

 */
 
//function DataFechArray() {return $this->obj->DataFechArray();}

function fldinf($i) {return $this->obj->fldinf($i);}

/**

 *      Lectura de la informacion de la cantidad de campos del conjunto de registros devueltos por la ejecucion de una instruccion SQL

 *      @return integer Valor que representa la cantidad de campos.

 */

function numfld() {return $this->obj->numfld();}

/**

 *      Desplazamiento al primer registro del conjunto de registros devueltos por la ejecucion de una instruccion SQL

 *      @return integer Posicionamiento en el primer registro

 */

function movefirst() {return $this->obj->movefirst();}

/**

 *      Desplazamiento al primer campo del conjunto de registros devueltos por la ejecucion de una instruccion SQL

 *      @return integer Posicionamiento en el primer campo del registro

 */

function movefirstfld() {return $this->obj->movefirstfld();}

/**

 *      Desplazamiento a un registro dado del conjunto de registros devueltos por la ejecucion de una instruccion SQL

 *      @param integer Numero de registro al cual se quiere desplazar

 *      @return integer Posicionamiento en el primer registro

 */

function movemyr($pos) {return $this->obj->movemyr($pos);}

/**

 *      Cuenta el conjunto de registros devueltos por la ejecucion de una instruccion SQL

 *      @return integer Numero de registros contados

 */

function count() {return $this->obj->count();}

/**

 *      Cierra la conexion a la base de datos (en desuso, ya que una vez que culmina el script se cierra la conexion)

 */

function close() {$this->obj->close();}

/**

 *      Lectura de todos los registros del conjunto de registros devueltos por la ejecucion de una instruccion SQL

 *      @return Matriz Matriz donde cada elemento es del tipo campo=>valor

 */

function DatosArray(){

  $datos_salida=array();

  while ($data=$this->obj->DataArray()){

    if (sizeof($data)>0){

      $datos_salida[]=$data;

    }

  }

  return $datos_salida;

}



/**

 *      Lectura de todos los registros del conjunto de registros devueltos por la ejecucion de una instruccion SQL

 *      @return matriz Matriz de Objeto donde los datos son accesados solo por el nombre del campo

 */



function DatosObjeto(){

  $datos_salida=array();

  while ($data=$this->obj->DataObjeto()){

    $datos_salida[]=$data;

  }

  return $datos_salida;

}


function __destruct(){

  if ($this->p_auditoria){

    $archivo_log="log".date("dmY").".txt";

    $ip=$_SERVER['REMOTE_ADDR'];

    $script=$_SERVER['SCRIPT_NAME'];

    $contenido=date("d/m/Y h:i:s")."|".$_SESSION['usr_desc']."|".$ip."|".$script."|".$this->tipo;

    $contenido.="|".$this->p_query."\r\n";

    $gestor=fopen('/opt/bcoexlib/log/'.$archivo_log,"a");

    fwrite($gestor,$contenido);

    fclose($gestor);

  }

}

/***function __destruct(){

  if ($this->p_auditoria){

    $archivo_log="log".date("dmY").".gz";

    $ip=$_SERVER['REMOTE_ADDR'];

    $script=$_SERVER['SCRIPT_NAME'];

    $contenido="FECHA:".date("d/m/Y h:i:s")."|USUARIO:".$_SESSION['sesion']['usr_desc']."|IP:".$ip."|SCRIPT:".$script."|BASE DE DATOS:".$this->p_tipo;

    $contenido.="|QUERY:".$this->p_query."\r\n";

    $gestor=gzopen($_SESSION['conf']['ruta_ficheros']['aplicacion']."log\\".$archivo_log,"a9");

    gzwrite($gestor,$contenido);

    gzclose($gestor);

    $gestor=gzopen($_SESSION['conf']['ruta_ficheros']['aplicacion']."log\\".$archivo_log,"r");

    echo gzread($gestor, 1000000);

    gzclose($gestor);

  }

}   ***/



}

?>
